<?php
/**
 * Rascals King Composer Extensions
 *
 *
 * @author Rascals Themes
 * @category Core
 * @package Meloo Toolkit
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Plugin Toolkit Class 
$toolkit = melooToolkit();

// Backup Main WP Query 
if ( isset( $post ) && isset( $wp_query ) ) { 
    $temp_post = $post;
    $query_temp = $wp_query;
}

// Set color scheme 
if ( isset( $atts['classes'] ) ) {
    $atts['classes'] .= ' ' . $atts['color_scheme'] . '-scheme-el';
}

// Kingcomposer wrapper class for each element 
$wrap_class = apply_filters( 'kc-el-class', $atts );

// Add custom classes to element 
$wrap_class[] = 'kc-instagram';
$wrap_class[] = 'rt-instagram';
$wrap_class[] = $atts['size'];

?>
<div class="<?php echo esc_attr( implode(' ', $wrap_class) ); ?> <?php echo esc_attr( $atts['classes'] ); ?>">
    <?php
    // Instafeed data 
    $saved_data = false;
    
    // Instagram id is not set 
    if ( empty( $atts['id'] ) ) {
        return esc_html_e( 'Render failed - no data is received, please check the ID', 'meloo-toolkit' );
    }

    // Set cache key 
    $cache_key = 'rt_instafeed_' . $atts['id'];

    // Remove @ from user id 
    $check_char = strpos( $atts['id'], '@' );
    if ( $check_char !== false ) {
        $atts['id'] = substr( $atts['id'], $check_char + 1 );
    }

    // Check cache 
    if ( false === ( $cache_task = get_transient( $cache_key ) ) ) {

        // Return the serialized data present in the page script 
        $response = wp_remote_get( 'https://www.instagram.com/' . esc_attr( $atts['id'] ), array(
            'timeout' => esc_attr( 60*$atts['request_timeout'] ),
            'sslverify' => false,
            'user-agent' => 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:35.0) Gecko/20100101 Firefox/35.0'
        ));

        if ( is_wp_error( $response ) ) {
             // error handling 
            $error_message = $response->get_error_message();
            return esc_html_e( "Something went wrong:", 'meloo-toolkit' ) . $error_message;
        }

        $request_output = wp_remote_retrieve_body( $response );
        if ( $request_output === '' ) {
            return esc_html_e( "Something went wrong", 'meloo-toolkit' );
        }

        // get the serialized data string present in the page script 
        $pattern = '/window\._sharedData = (.*);<\/script>/';
        preg_match( $pattern, $request_output, $matches );

        if ( ! empty( $matches[1] ) ) {
            $request_output = $matches[1];
        } else {
            return esc_html_e( 'Instagram html data cannot be retrieved', 'meloo-toolkit' );
        }

        // JSON Decode 
        $json = json_decode( $request_output, true );
        if ( $json === null and json_last_error() !== JSON_ERROR_NONE ) {
            return esc_html_e( 'Error decoding the instagram json', 'meloo-toolkit' );
        }

        if ( !isset( $json['entry_data']['ProfilePage'][0]['graphql']['user'] ) ) {
            return esc_html_e( 'Instagram data is not set, plese check your ID', 'meloo-toolkit' );
        }

        $saved_data = $json['entry_data']['ProfilePage'][0]['graphql']['user'];

        // Set cache 
        set_transient( $cache_key, $saved_data, 60 * $atts['cache_time'] );

    } 

    // Set number of images 
    $images_per_row = intval( $atts['images_per_row'] );
    $number_of_rows = intval( $atts['number_of_rows'] );
    $images_nr = $images_per_row * $number_of_rows;

    // Get feed from cache 
    $cache_task = get_transient( $cache_key );
    if ( $cache_task === false && $saved_data !== false  ) {
        $cache_task = $saved_data;
    } 

    // Profile image 
    $profile_img = '';
    if ( isset( $cache_task['profile_pic_url'] ) ) {
        $profile_img = $cache_task['profile_pic_url'];
    }

    // Followers 
    $followers = 0;
    if ( isset( $cache_task['edge_followed_by']['count'] ) ) {
        $followers = $cache_task['edge_followed_by']['count'];
    }

    $followers = meloo_format_number( $followers );

    ?>
    <?php if ( ! empty( $atts['display_header'] ) ) : ?>
        <div class="rt-instagram-header">
            <div class="rt-instagram-profile-img">
                <img src="<?php echo esc_url( $profile_img ); ?>" alt="<?php echo esc_attr__( 'Instagram profile image', 'meloo-toolkit' ); ?>">
            </div>
            <div class="rt-instagram-data">
                <div class="rt-instagram-user">
                    <a target="_blank" href="https://www.instagram.com/<?php echo esc_attr( $atts['id'] ); ?>">
                        <?php if ( ! empty( $atts['display_name'] ) ) : ?>
                            @<?php echo esc_attr( $atts['display_name'] ); ?>
                        <?php else : ?>
                            @<?php echo esc_attr( $atts['id'] ); ?>
                        <?php endif ?>
                    </a>
                </div>
                <div class="rt-instagram-followers">
                    <span><?php echo esc_attr( $followers ); ?></span><?php esc_html_e( 'Followers', 'meloo-toolkit' ); ?>
                </div>
                <a class="rt-instagram-button" target="_blank" href="https://www.instagram.com/<?php echo esc_attr( $atts['id'] ); ?>"><?php esc_html_e( 'Follow', 'meloo-toolkit' ); ?></a>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if ( isset( $cache_task['edge_owner_to_timeline_media']['edges'] ) ) : ?>
        <?php $image_count = 0; ?>
        <div class="rt-instagram-images rt-instagram-grid-<?php echo esc_attr( $atts['images_per_row'] ); ?> <?php echo esc_attr( $atts['image_gap'] ); ?>">
        <?php foreach ( $cache_task['edge_owner_to_timeline_media']['edges'] as $image ) : ?>
            <?php if ( isset( $image['node']['shortcode'] ) && isset( $image['node']['thumbnail_src'] ) ) : ?>

                    <div class="rt-instagram-image">
                        <a href="https://www.instagram.com/p/<?php echo esc_attr( $image['node']['shortcode'] ); ?>" target="_blank">
                            <img src="<?php echo esc_url( $image['node']['thumbnail_src'] ); ?>" alt="<?php echo esc_attr__( 'Instagram image', 'meloo-toolkit' ); ?>">
                        </a>
                        <div class="rt-instagram-meta">
                            <div>
                                <span class="rt-instagram-comments"><i class="icon icon-comment-o"></i><?php echo meloo_format_number($image['node']['edge_media_to_comment']['count'] ); ?></span>
                                <span class="rt-instagram-likes"><i class="icon icon-heart-o"></i><?php echo meloo_format_number( $image['node']['edge_media_preview_like']['count'] ); ?></span>
                            </div>
                        </div>

                    </div>
            <?php endif ?>

            <?php 
                $image_count ++;
                if ( $image_count === $images_nr ) {
                    break;
                }
            ?>

        <?php endforeach; ?>

        <?php if ( ! empty( $atts['display_follow_overlay'] ) ) : ?>
            <div class="follow-overlay">
                <h6>
                    <a target="_blank" href="https://www.instagram.com/<?php echo esc_attr( $atts['id'] ); ?>">
                        <?php if ( ! empty( $atts['display_name'] ) ) : ?>
                            @<?php echo esc_attr( $atts['display_name'] ); ?>
                        <?php else : ?>
                            @<?php echo esc_attr( $atts['id'] ); ?>
                        <?php endif ?>
                    </a>
                </h6>
            </div>
        <?php endif ?>
        </div>

    <?php endif ?>

</div>

<?php
    // Restore Main WP Query 
    if ( isset( $post ) && isset( $wp_query ) ) { 
        $post = $temp_post;
        $wp_query = $query_temp;
    }
?>