/** @license
 *
 * SoundManager 2: JavaScript Sound for the Web
 * ----------------------------------------------
 * http://schillmania.com/projects/soundmanager2/
 *
 * Copyright (c) 2007, Scott Schiller. All rights reserved.
 * Code provided under the BSD License:
 * http://schillmania.com/projects/soundmanager2/license.txt
 *
 * V2.97a.20170601
 */
(function SM2(c,d){if(!c||!c.document){throw new Error("SoundManager requires a browser with window and document objects.");}var b=null;function a(a1,aj){this.setupOptions={url:(a1||null),flashVersion:8,debugMode:true,debugFlash:false,useConsole:true,consoleOnly:true,waitForWindowLoad:false,bgColor:"#ffffff",useHighPerformance:false,flashPollingInterval:null,html5PollingInterval:null,flashLoadTimeout:1000,wmode:null,allowScriptAccess:"always",useFlashBlock:false,useHTML5Audio:true,forceUseGlobalHTML5Audio:false,ignoreMobileRestrictions:false,html5Test:/^(probably|maybe)$/i,preferFlash:false,noSWFCache:false,idPrefix:"sound"};
this.defaultOptions={autoLoad:false,autoPlay:false,from:null,loops:1,onid3:null,onerror:null,onload:null,whileloading:null,onplay:null,onpause:null,onresume:null,whileplaying:null,onposition:null,onstop:null,onfinish:null,multiShot:true,multiShotEvents:false,position:null,pan:0,playbackRate:1,stream:true,to:null,type:null,usePolicyFile:false,volume:100};
this.flash9Options={onfailure:null,isMovieStar:null,usePeakData:false,useWaveformData:false,useEQData:false,onbufferchange:null,ondataerror:null};this.movieStarOptions={bufferTime:3,serverURL:null,onconnect:null,duration:null};
this.audioFormats={mp3:{type:['audio/mpeg; codecs="mp3"',"audio/mpeg","audio/mp3","audio/MPA","audio/mpa-robust"],required:true},mp4:{related:["aac","m4a","m4b"],type:['audio/mp4; codecs="mp4a.40.2"',"audio/aac","audio/x-m4a","audio/MP4A-LATM","audio/mpeg4-generic"],required:false},ogg:{type:["audio/ogg; codecs=vorbis"],required:false},opus:{type:["audio/ogg; codecs=opus","audio/opus"],required:false},wav:{type:['audio/wav; codecs="1"',"audio/wav","audio/wave","audio/x-wav"],required:false},flac:{type:["audio/flac"],required:false}};
this.movieID="sm2-container";this.id=(aj||"sm2movie");this.debugID="soundmanager-debug";this.debugURLParam=/([#?&])debug=1/i;this.versionNumber="V2.97a.20170601";
this.version=null;this.movieURL=null;this.altURL=null;this.swfLoaded=false;this.enabled=false;this.oMC=null;this.sounds={};this.soundIDs=[];this.muted=false;
this.didFlashBlock=false;this.filePattern=null;this.filePatterns={flash8:/\.mp3(\?.*)?$/i,flash9:/\.mp3(\?.*)?$/i};this.features={buffering:false,peakData:false,waveformData:false,eqData:false,movieStar:false};
this.sandbox={};this.html5={usingFlash:null};this.flash={};this.html5Only=false;this.ignoreFlash=false;var al,ap=this,a9=null,ad=null,aY="soundManager",F=aY+": ",a5="HTML5::",ao,av=navigator.userAgent,x=c.location.href.toString(),Z=document,T,z,aJ,bi,v=[],bh=true,M,aq=false,aV=false,ay=false,a2=false,bc=false,V,ax=0,w,a3,a7,a4,Y,aS,s,y,bd,ac,aW,t,e,j,L,bk,p,bg,H,aa,l,D,aH=["log","info","warn","error"],X=8,W,r,aA,aK=null,ak=null,bf,aB,m,E,aD,A,o,at,I,aR=false,aI=false,aP,N,ae,K=0,be=null,ab,ar=[],af,B=null,S,bb,an,aO,aL,g,O,aN,am,R=Array.prototype.slice,a0=false,k,au,Q,C,i,aF,P,aE,ah=0,ag,h=1000,aX=av.match(/(ipad|iphone|ipod)/i),aw=av.match(/android/i),a8=av.match(/msie|trident/i),aG=av.match(/webkit/i),aZ=(av.match(/safari/i)&&!av.match(/chrome/i)),u=(av.match(/opera/i)),aU=(av.match(/(mobile|pre\/|xoom)/i)||aX||aw),a6=(!x.match(/usehtml5audio/i)&&!x.match(/sm2-ignorebadua/i)&&aZ&&!av.match(/silk/i)&&av.match(/OS\sX\s10_6_([3-7])/i)),J=(c.console!==d&&console.log!==d),aC=(Z.hasFocus!==d?Z.hasFocus():null),ba=(aZ&&(Z.hasFocus===d||!Z.hasFocus())),az=!ba,q=/(mp3|mp4|mpa|m4a|m4b)/i,n="about:blank",aT="data:audio/wave;base64,/UklGRiYAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQIAAAD//w==",G=(Z.location?Z.location.protocol.match(/http/i):null),aM=(!G?"//":""),f=/^\s*audio\/(?:x-)?(?:mpeg4|aac|flv|mov|mp4|m4v|m4a|m4b|mp4v|3gp|3g2)\s*(?:$|;)/i,U=["mpeg4","aac","flv","mov","mp4","m4v","f4v","m4a","m4b","mp4v","3gp","3g2"],ai=new RegExp("\\.("+U.join("|")+")(\\?.*)?$","i");
this.mimePattern=/^\s*audio\/(?:x-)?(?:mp(?:eg|3))\s*(?:$|;)/i;this.useAltURL=!G;E={swfBox:"sm2-object-box",swfDefault:"movieContainer",swfError:"swf_error",swfTimedout:"swf_timedout",swfLoaded:"swf_loaded",swfUnblocked:"swf_unblocked",sm2Debug:"sm2_debug",highPerf:"high_performance",flashDebug:"flash_debug"};
aO=[null,"MEDIA_ERR_ABORTED","MEDIA_ERR_NETWORK","MEDIA_ERR_DECODE","MEDIA_ERR_SRC_NOT_SUPPORTED"];this.hasHTML5=(function(){try{return(Audio!==d&&(u&&opera!==d&&opera.version()<10?new Audio(null):new Audio()).canPlayType!==d);
}catch(bl){return false;}}());this.setup=function(bl){var bm=(!ap.url);if(bl!==d&&ay&&B&&ap.ok()&&(bl.flashVersion!==d||bl.url!==d||bl.html5Test!==d)){}a7(bl);
if(!a0){if(aU){if(!ap.setupOptions.ignoreMobileRestrictions||ap.setupOptions.forceUseGlobalHTML5Audio){ar.push(e.globalHTML5);a0=true;}}else{if(ap.setupOptions.forceUseGlobalHTML5Audio){ar.push(e.globalHTML5);
a0=true;}}}if(!ag&&aU){if(ap.setupOptions.ignoreMobileRestrictions){ar.push(e.ignoreMobile);}else{ap.setupOptions.useHTML5Audio=true;ap.setupOptions.preferFlash=false;
if(aX){ap.ignoreFlash=true;}else{if((aw&&!av.match(/android\s2\.3/i))||!aw){a0=true;}}}}if(bl){if(bm&&p&&bl.url!==d){ap.beginDelayedInit();}if(!p&&bl.url!==d&&Z.readyState==="complete"){setTimeout(L,1);
}}ag=true;return ap;};this.ok=function(){return(B?(ay&&!a2):(ap.useHTML5Audio&&ap.hasHTML5));};this.supported=this.ok;this.getMovie=function(bl){return ao(bl)||Z[bl]||c[bl];
};this.createSound=function(bn,bp){var bq,br,bm,bo=null;if(!ay||!ap.ok()){return false;}if(bp!==d){bn={id:bn,url:bp};}bm=a3(bn);bm.url=ab(bm.url);if(bm.id===d){bm.id=ap.setupOptions.idPrefix+(ah++);
}if(I(bm.id,true)){return ap.sounds[bm.id];}function bl(){bm=A(bm);ap.sounds[bm.id]=new al(bm);ap.soundIDs.push(bm.id);return ap.sounds[bm.id];}if(bb(bm)){bo=bl();
bo._setup_html5(bm);}else{if(ap.html5Only){return bl();}if(ap.html5.usingFlash&&bm.url&&bm.url.match(/data:/i)){return bl();}if(bi>8){if(bm.isMovieStar===null){bm.isMovieStar=!!(bm.serverURL||(bm.type?bm.type.match(f):false)||(bm.url&&bm.url.match(ai)));
}}bm=o(bm,bq);bo=bl();if(bi===8){ad._createSound(bm.id,bm.loops||1,bm.usePolicyFile);}else{ad._createSound(bm.id,bm.url,bm.usePeakData,bm.useWaveformData,bm.useEQData,bm.isMovieStar,(bm.isMovieStar?bm.bufferTime:false),bm.loops||1,bm.serverURL,bm.duration||null,bm.autoPlay,true,bm.autoLoad,bm.usePolicyFile);
if(!bm.serverURL){bo.connected=true;if(bm.onconnect){bm.onconnect.apply(bo);}}}if(!bm.serverURL&&(bm.autoLoad||bm.autoPlay)){bo.load(bm);}}if(!bm.serverURL&&bm.autoPlay){bo.play();
}return bo;};this.destroySound=function(bl,bo){if(!I(bl)){return false;}var bn=ap.sounds[bl],bm;bn.stop();bn._iO={};bn.unload();for(bm=0;bm<ap.soundIDs.length;
bm++){if(ap.soundIDs[bm]===bl){ap.soundIDs.splice(bm,1);break;}}if(!bo){bn.destruct(true);}bn=null;delete ap.sounds[bl];return true;};this.load=function(bl,bm){if(!I(bl)){return false;
}return ap.sounds[bl].load(bm);};this.unload=function(bl){if(!I(bl)){return false;}return ap.sounds[bl].unload();};this.onPosition=function(bo,bn,bm,bl){if(!I(bo)){return false;
}return ap.sounds[bo].onposition(bn,bm,bl);};this.onposition=this.onPosition;this.clearOnPosition=function(bn,bm,bl){if(!I(bn)){return false;}return ap.sounds[bn].clearOnPosition(bm,bl);
};this.play=function(bn,bo){var bl=null,bm=(bo&&!(bo instanceof Object));if(!ay||!ap.ok()){return false;}if(!I(bn,bm)){if(!bm){return false;}if(bm){bo={url:bo};
}if(bo&&bo.url){bo.id=bn;bl=ap.createSound(bo).play();}}else{if(bm){bo={url:bo};}}if(bl===null){bl=ap.sounds[bn].play(bo);}return bl;};this.start=this.play;
this.setPlaybackRate=function(bl,bm,bn){if(!I(bl)){return false;}return ap.sounds[bl].setPlaybackRate(bm,bn);};this.setPosition=function(bl,bm){if(!I(bl)){return false;
}return ap.sounds[bl].setPosition(bm);};this.stop=function(bl){if(!I(bl)){return false;}return ap.sounds[bl].stop();};this.stopAll=function(){var bl;for(bl in ap.sounds){if(ap.sounds.hasOwnProperty(bl)){ap.sounds[bl].stop();
}}};this.pause=function(bl){if(!I(bl)){return false;}return ap.sounds[bl].pause();};this.pauseAll=function(){var bl;for(bl=ap.soundIDs.length-1;bl>=0;bl--){ap.sounds[ap.soundIDs[bl]].pause();
}};this.resume=function(bl){if(!I(bl)){return false;}return ap.sounds[bl].resume();};this.resumeAll=function(){var bl;for(bl=ap.soundIDs.length-1;bl>=0;
bl--){ap.sounds[ap.soundIDs[bl]].resume();}};this.togglePause=function(bl){if(!I(bl)){return false;}return ap.sounds[bl].togglePause();};this.setPan=function(bl,bm){if(!I(bl)){return false;
}return ap.sounds[bl].setPan(bm);};this.setVolume=function(bm,bl){var bo,bn;if(bm!==d&&!isNaN(bm)&&bl===d){for(bo=0,bn=ap.soundIDs.length;bo<bn;bo++){ap.sounds[ap.soundIDs[bo]].setVolume(bm);
}return false;}if(!I(bm)){return false;}return ap.sounds[bm].setVolume(bl);};this.mute=function(bl){var bm=0;if(bl instanceof String){bl=null;}if(!bl){for(bm=ap.soundIDs.length-1;
bm>=0;bm--){ap.sounds[ap.soundIDs[bm]].mute();}ap.muted=true;}else{if(!I(bl)){return false;}return ap.sounds[bl].mute();}return true;};this.muteAll=function(){ap.mute();
};this.unmute=function(bl){var bm;if(bl instanceof String){bl=null;}if(!bl){for(bm=ap.soundIDs.length-1;bm>=0;bm--){ap.sounds[ap.soundIDs[bm]].unmute();
}ap.muted=false;}else{if(!I(bl)){return false;}return ap.sounds[bl].unmute();}return true;};this.unmuteAll=function(){ap.unmute();};this.toggleMute=function(bl){if(!I(bl)){return false;
}return ap.sounds[bl].toggleMute();};this.getMemoryUse=function(){var bl=0;if(ad&&bi!==8){bl=parseInt(ad._getMemoryUse(),10);}return bl;};this.disable=function(bm){var bl;
if(bm===d){bm=false;}if(a2){return false;}a2=true;for(bl=ap.soundIDs.length-1;bl>=0;bl--){W(ap.sounds[ap.soundIDs[bl]]);}W(ap);w(bm);am.remove(c,"load",s);
return true;};this.canPlayMIME=function(bm){var bl;if(ap.hasHTML5){bl=an({type:bm});}if(!bl&&B){bl=(bm&&ap.ok()?!!((bi>8?bm.match(f):null)||bm.match(ap.mimePattern)):null);
}return bl;};this.canPlayURL=function(bm){var bl;if(ap.hasHTML5){bl=an({url:bm});}if(!bl&&B){bl=(bm&&ap.ok()?!!(bm.match(ap.filePattern)):null);}return bl;
};this.canPlayLink=function(bl){if(bl.type!==d&&bl.type&&ap.canPlayMIME(bl.type)){return true;}return ap.canPlayURL(bl.href);};this.getSoundById=function(bm,bn){if(!bm){return null;
}var bl=ap.sounds[bm];return bl;};this.onready=function(bn,bm){var bo="onready",bl=false;if(typeof bn==="function"){if(!bm){bm=c;}Y(bo,bn,bm);aS();bl=true;
}else{throw bf("needFunction",bo);}return bl;};this.ontimeout=function(bn,bm){var bo="ontimeout",bl=false;if(typeof bn==="function"){if(!bm){bm=c;}Y(bo,bn,bm);
aS({type:bo});bl=true;}else{throw bf("needFunction",bo);}return bl;};this._writeDebug=function(bm,bl){return true;};this._wD=this._writeDebug;this._debug=function(){};
this.reboot=function(bp,bo){var bn,bm,bl;for(bn=ap.soundIDs.length-1;bn>=0;bn--){ap.sounds[ap.soundIDs[bn]].destruct();}if(ad){try{if(a8){ak=ad.innerHTML;
}aK=ad.parentNode.removeChild(ad);}catch(bq){}}ak=aK=B=ad=null;ap.enabled=p=ay=aR=aI=aq=aV=a2=a0=ap.swfLoaded=false;ap.soundIDs=[];ap.sounds={};ah=0;ag=false;
if(!bp){for(bn in v){if(v.hasOwnProperty(bn)){for(bm=0,bl=v[bn].length;bm<bl;bm++){v[bn][bm].fired=false;}}}}else{v=[];}ap.html5={usingFlash:null};ap.flash={};
ap.html5Only=false;ap.ignoreFlash=false;c.setTimeout(function(){if(!bo){ap.beginDelayedInit();}},20);return ap;};this.reset=function(){return ap.reboot(true,true);
};this.getMoviePercent=function(){return(ad&&"PercentLoaded" in ad?ad.PercentLoaded():null);};this.beginDelayedInit=function(){bc=true;L();setTimeout(function(){if(aI){return false;
}H();j();aI=true;return true;},20);y();};this.destruct=function(){ap.disable(true);};al=function(bz){var bA=this,bl,bw,bt,bm,bq,br,bn=false,bp=[],bx=0,bo,bs,bu=null,bv,by;
bv={duration:null,time:null};this.id=bz.id;this.sID=this.id;this.url=bz.url;this.options=a3(bz);this.instanceOptions=this.options;this._iO=this.instanceOptions;
this.pan=this.options.pan;this.volume=this.options.volume;this.isHTML5=false;this._a=null;by=(!this.url);this.id3={};this._debug=function(){};this.load=function(bB){var bC=null,bD;
if(bB!==d){bA._iO=a3(bB,bA.options);}else{bB=bA.options;bA._iO=bB;if(bu&&bu!==bA.url){bA._iO.url=bA.url;bA.url=null;}}if(!bA._iO.url){bA._iO.url=bA.url;
}bA._iO.url=ab(bA._iO.url);bA.instanceOptions=bA._iO;bD=bA._iO;if(!bD.url&&!bA.url){return bA;}if(bD.url===bA.url&&bA.readyState!==0&&bA.readyState!==2){if(bA.readyState===3&&bD.onload){aE(bA,function(){bD.onload.apply(bA,[(!!bA.duration)]);
});}return bA;}bA.loaded=false;bA.readyState=1;bA.playState=0;bA.id3={};if(bb(bD)){bC=bA._setup_html5(bD);if(!bC._called_load){bA._html5_canplay=false;
if(bA.url!==bD.url){bA._a.src=bD.url;bA.setPosition(0);}bA._a.autobuffer="auto";bA._a.preload="auto";bA._a._called_load=true;}else{}}else{if(ap.html5Only){return bA;
}if(bA._iO.url&&bA._iO.url.match(/data:/i)){return bA;}try{bA.isHTML5=false;bA._iO=o(A(bD));if(bA._iO.autoPlay&&(bA._iO.position||bA._iO.from)){bA._iO.autoPlay=false;
}bD=bA._iO;if(bi===8){ad._load(bA.id,bD.url,bD.stream,bD.autoPlay,bD.usePolicyFile);}else{ad._load(bA.id,bD.url,!!(bD.stream),!!(bD.autoPlay),bD.loops||1,!!(bD.autoLoad),bD.usePolicyFile);
}}catch(bE){aa({type:"SMSOUND_LOAD_JS_EXCEPTION",fatal:true});}}bA.url=bD.url;return bA;};this.unload=function(){if(bA.readyState!==0){if(!bA.isHTML5){if(bi===8){ad._unload(bA.id,n);
}else{ad._unload(bA.id);}}else{bm();if(bA._a){bA._a.pause();bu=g(bA._a);}}bl();}return bA;};this.destruct=function(bB){if(!bA.isHTML5){bA._iO.onfailure=null;
ad._destroySound(bA.id);}else{bm();if(bA._a){bA._a.pause();g(bA._a);if(!a0){bt();}bA._a._s=null;bA._a=null;}}if(!bB){ap.destroySound(bA.id,true);}};this.play=function(bK,bC){var bB,bD,bI,bH,bJ,bG,bF,bE=true;
bC=(bC===d?true:bC);if(!bK){bK={};}if(bA.url){bA._iO.url=bA.url;}bA._iO=a3(bA._iO,bA.options);bA._iO=a3(bK,bA._iO);bA._iO.url=ab(bA._iO.url);bA.instanceOptions=bA._iO;
if(!bA.isHTML5&&bA._iO.serverURL&&!bA.connected){if(!bA.getAutoPlay()){bA.setAutoPlay(true);}return bA;}if(bb(bA._iO)){bA._setup_html5(bA._iO);bq();}if(bA.playState===1&&!bA.paused){bD=bA._iO.multiShot;
if(!bD){if(bA.isHTML5){bA.setPosition(bA._iO.position);}return bA;}}if(bK.url&&bK.url!==bA.url){if(!bA.readyState&&!bA.isHTML5&&bi===8&&by){by=false;}else{bA.load(bA._iO);
}}if(!bA.loaded){if(bA.readyState===0){if(!bA.isHTML5&&!ap.html5Only){bA._iO.autoPlay=true;bA.load(bA._iO);}else{if(bA.isHTML5){bA.load(bA._iO);}else{return bA;
}}bA.instanceOptions=bA._iO;}else{if(bA.readyState===2){return bA;}else{}}}else{}if(!bA.isHTML5&&bi===9&&bA.position>0&&bA.position===bA.duration){bK.position=0;
}if(bA.paused&&bA.position>=0&&(!bA._iO.serverURL||bA.position>0)){bA.resume();}else{bA._iO=a3(bK,bA._iO);if(((!bA.isHTML5&&bA._iO.position!==null&&bA._iO.position>0)||(bA._iO.from!==null&&bA._iO.from>0)||bA._iO.to!==null)&&bA.instanceCount===0&&bA.playState===0&&!bA._iO.serverURL){bH=function(){bA._iO=a3(bK,bA._iO);
bA.play(bA._iO);};if(bA.isHTML5&&!bA._html5_canplay){bA.load({_oncanplay:bH});}else{if(!bA.isHTML5&&!bA.loaded&&(!bA.readyState||bA.readyState!==2)){bA.load({onload:bH});
}}bA._iO=bs();}if(!bA.instanceCount||bA._iO.multiShotEvents||(bA.isHTML5&&bA._iO.multiShot&&!a0)||(!bA.isHTML5&&bi>8&&!bA.getAutoPlay())){bA.instanceCount++;
}if(bA._iO.onposition&&bA.playState===0){br(bA);}bA.playState=1;bA.paused=false;bA.position=(bA._iO.position!==d&&!isNaN(bA._iO.position)?bA._iO.position:0);
if(!bA.isHTML5){bA._iO=o(A(bA._iO));}if(bA._iO.onplay&&bC){bA._iO.onplay.apply(bA);bn=true;}bA.setVolume(bA._iO.volume,true);bA.setPan(bA._iO.pan,true);
if(bA._iO.playbackRate!==1){bA.setPlaybackRate(bA._iO.playbackRate);}if(!bA.isHTML5){bE=ad._start(bA.id,bA._iO.loops||1,(bi===9?bA.position:bA.position/h),bA._iO.multiShot||false);
if(bi===9&&!bE){if(bA._iO.onplayerror){bA._iO.onplayerror.apply(bA);}}}else{if(bA.instanceCount<2){bq();bI=bA._setup_html5();bA.setPosition(bA._iO.position);
bI.play();}}}return bA;};this.start=this.play;this.stop=function(bB){var bD=bA._iO,bC;if(bA.playState===1){bA._onbufferchange(0);bA._resetOnPosition(0);
bA.paused=false;if(!bA.isHTML5){bA.playState=0;}bo();if(bD.to){bA.clearOnPosition(bD.to);}if(!bA.isHTML5){ad._stop(bA.id,bB);if(bD.serverURL){bA.unload();
}}else{if(bA._a){bC=bA.position;bA.setPosition(0);bA.position=bC;bA._a.pause();bA.playState=0;bA._onTimer();bm();}}bA.instanceCount=0;bA._iO={};if(bD.onstop){bD.onstop.apply(bA);
}}return bA;};this.setAutoPlay=function(bB){bA._iO.autoPlay=bB;if(!bA.isHTML5){ad._setAutoPlay(bA.id,bB);if(bB){if(!bA.instanceCount&&bA.readyState===1){bA.instanceCount++;
}}}};this.getAutoPlay=function(){return bA._iO.autoPlay;};this.setPlaybackRate=function(bB){var bD=Math.max(0.5,Math.min(4,bB));if(bA.isHTML5){try{bA._iO.playbackRate=bD;
bA._a.playbackRate=bD;}catch(bC){}}return bA;};this.setPosition=function(bD){if(bD===d){bD=0;}var bB,bC,bF=(bA.isHTML5?Math.max(bD,0):Math.min(bA.duration||bA._iO.duration,Math.max(bD,0)));
bA.position=bF;bC=bA.position/h;bA._resetOnPosition(bA.position);bA._iO.position=bF;if(!bA.isHTML5){bB=(bi===9?bA.position:bC);if(bA.readyState&&bA.readyState!==2){ad._setPosition(bA.id,bB,(bA.paused||!bA.playState),bA._iO.multiShot);
}}else{if(bA._a){if(bA._html5_canplay){if(bA._a.currentTime.toFixed(3)!==bC.toFixed(3)){try{bA._a.currentTime=bC;if(bA.playState===0||bA.paused){bA._a.pause();
}}catch(bE){}}}else{if(bC){return bA;}}if(bA.paused){bA._onTimer(true);}}}return bA;};this.pause=function(bB){if(bA.paused||(bA.playState===0&&bA.readyState!==1)){return bA;
}bA.paused=true;if(!bA.isHTML5){if(bB||bB===d){ad._pause(bA.id,bA._iO.multiShot);}}else{bA._setup_html5().pause();bm();}if(bA._iO.onpause){bA._iO.onpause.apply(bA);
}return bA;};this.resume=function(){var bB=bA._iO;if(!bA.paused){return bA;}bA.paused=false;bA.playState=1;if(!bA.isHTML5){if(bB.isMovieStar&&!bB.serverURL){bA.setPosition(bA.position);
}ad._pause(bA.id,bB.multiShot);}else{bA._setup_html5().play();bq();}if(!bn&&bB.onplay){bB.onplay.apply(bA);bn=true;}else{if(bB.onresume){bB.onresume.apply(bA);
}}return bA;};this.togglePause=function(){if(bA.playState===0){bA.play({position:(bi===9&&!bA.isHTML5?bA.position:bA.position/h)});return bA;}if(bA.paused){bA.resume();
}else{bA.pause();}return bA;};this.setPan=function(bC,bB){if(bC===d){bC=0;}if(bB===d){bB=false;}if(!bA.isHTML5){ad._setPan(bA.id,bC);}bA._iO.pan=bC;if(!bB){bA.pan=bC;
bA.options.pan=bC;}return bA;};this.setVolume=function(bB,bC){if(bB===d){bB=100;}if(bC===d){bC=false;}if(!bA.isHTML5){ad._setVolume(bA.id,(ap.muted&&!bA.muted)||bA.muted?0:bB);
}else{if(bA._a){if(ap.muted&&!bA.muted){bA.muted=true;bA._a.muted=true;}bA._a.volume=Math.max(0,Math.min(1,bB/100));}}bA._iO.volume=bB;if(!bC){bA.volume=bB;
bA.options.volume=bB;}return bA;};this.mute=function(){bA.muted=true;if(!bA.isHTML5){ad._setVolume(bA.id,0);}else{if(bA._a){bA._a.muted=true;}}return bA;
};this.unmute=function(){bA.muted=false;var bB=(bA._iO.volume!==d);if(!bA.isHTML5){ad._setVolume(bA.id,bB?bA._iO.volume:bA.options.volume);}else{if(bA._a){bA._a.muted=false;
}}return bA;};this.toggleMute=function(){return(bA.muted?bA.unmute():bA.mute());};this.onPosition=function(bD,bC,bB){bp.push({position:parseInt(bD,10),method:bC,scope:(bB!==d?bB:bA),fired:false});
return bA;};this.onposition=this.onPosition;this.clearOnPosition=function(bC,bB){var bD;bC=parseInt(bC,10);if(isNaN(bC)){return;}for(bD=0;bD<bp.length;
bD++){if(bC===bp[bD].position){if(!bB||(bB===bp[bD].method)){if(bp[bD].fired){bx--;}bp.splice(bD,1);}}}};this._processOnPosition=function(){var bC,bD,bB=bp.length;
if(!bB||!bA.playState||bx>=bB){return false;}for(bC=bB-1;bC>=0;bC--){bD=bp[bC];if(!bD.fired&&bA.position>=bD.position){bD.fired=true;bx++;bD.method.apply(bD.scope,[bD.position]);
bB=bp.length;}}return true;};this._resetOnPosition=function(bB){var bD,bE,bC=bp.length;if(!bC){return false;}for(bD=bC-1;bD>=0;bD--){bE=bp[bD];if(bE.fired&&bB<=bE.position){bE.fired=false;
bx--;}}return true;};bs=function(){var bE=bA._iO,bD=bE.from,bC=bE.to,bF,bB;bB=function(){bA.clearOnPosition(bC,bB);bA.stop();};bF=function(){if(bC!==null&&!isNaN(bC)){bA.onPosition(bC,bB);
}};if(bD!==null&&!isNaN(bD)){bE.position=bD;bE.multiShot=false;bF();}return bE;};br=function(){var bB,bC=bA._iO.onposition;if(bC){for(bB in bC){if(bC.hasOwnProperty(bB)){bA.onPosition(parseInt(bB,10),bC[bB]);
}}}};bo=function(){var bB,bC=bA._iO.onposition;if(bC){for(bB in bC){if(bC.hasOwnProperty(bB)){bA.clearOnPosition(parseInt(bB,10));}}}};bq=function(){if(bA.isHTML5){aP(bA);
}};bm=function(){if(bA.isHTML5){N(bA);}};bl=function(bB){if(!bB){bp=[];bx=0;}bn=false;bA._hasTimer=null;bA._a=null;bA._html5_canplay=false;bA.bytesLoaded=null;
bA.bytesTotal=null;bA.duration=(bA._iO&&bA._iO.duration?bA._iO.duration:null);bA.durationEstimate=null;bA.buffered=[];bA.eqData=[];bA.eqData.left=[];bA.eqData.right=[];
bA.failures=0;bA.isBuffering=false;bA.instanceOptions={};bA.instanceCount=0;bA.loaded=false;bA.metadata={};bA.readyState=0;bA.muted=false;bA.paused=false;
bA.peakData={left:0,right:0};bA.waveformData={left:[],right:[]};bA.playState=0;bA.position=null;bA.id3={};};bl();this._onTimer=function(bD){var bF,bC=false,bE,bB={};
if(bA._hasTimer||bD){if(bA._a&&(bD||((bA.playState>0||bA.readyState===1)&&!bA.paused))){bF=bA._get_html5_duration();if(bF!==bv.duration){bv.duration=bF;
bA.duration=bF;bC=true;}bA.durationEstimate=bA.duration;bE=(bA._a.currentTime*h||0);if(bE!==bv.time){bv.time=bE;bC=true;}if(bC||bD){bA._whileplaying(bE,bB,bB,bB,bB);
}}}return bC;};this._get_html5_duration=function(){var bC=bA._iO,bD=(bA._a&&bA._a.duration?bA._a.duration*h:(bC&&bC.duration?bC.duration:null)),bB=(bD&&!isNaN(bD)&&bD!==Infinity?bD:null);
return bB;};this._apply_loop=function(bB,bC){bB.loop=(bC>1?"loop":"");};this._setup_html5=function(bC){var bD=a3(bA._iO,bC),bB=a0?a9:bA._a,bF=decodeURI(bD.url),bE;
if(a0){if(bF===decodeURI(k)){bE=true;}}else{if(bF===decodeURI(bu)){bE=true;}}if(bB){if(bB._s){if(a0){if(bB._s&&bB._s.playState&&!bE){bB._s.stop();}}else{if(!a0&&bF===decodeURI(bu)){bA._apply_loop(bB,bD.loops);
return bB;}}}if(!bE){if(bu){bl(false);}bB.src=bD.url;bA.url=bD.url;bu=bD.url;k=bD.url;bB._called_load=false;}}else{if(bD.autoLoad||bD.autoPlay){bA._a=new Audio(bD.url);
bA._a.load();}else{bA._a=(u&&opera.version()<10?new Audio(null):new Audio());}bB=bA._a;bB._called_load=false;if(a0){a9=bB;}}bA.isHTML5=true;bA._a=bB;bB._s=bA;
bw();bA._apply_loop(bB,bD.loops);if(bD.autoLoad||bD.autoPlay){bA.load();}else{bB.autobuffer=false;bB.preload="auto";}return bB;};bw=function(){if(bA._a._added_events){return false;
}var bB;function bC(bE,bD,bF){return bA._a?bA._a.addEventListener(bE,bD,bF||false):null;}bA._a._added_events=true;for(bB in i){if(i.hasOwnProperty(bB)){bC(bB,i[bB]);
}}return true;};bt=function(){var bC;function bB(bE,bD,bF){return(bA._a?bA._a.removeEventListener(bE,bD,bF||false):null);}bA._a._added_events=false;for(bC in i){if(i.hasOwnProperty(bC)){bB(bC,i[bC]);
}}};this._onload=function(bD){var bB,bC=!!bD||(!bA.isHTML5&&bi===8&&bA.duration);bA.loaded=bC;bA.readyState=(bC?3:2);bA._onbufferchange(0);if(!bC&&!bA.isHTML5){bA._onerror();
}if(bA._iO.onload){aE(bA,function(){bA._iO.onload.apply(bA,[bC]);});}return true;};this._onerror=function(bC,bB){if(bA._iO.onerror){aE(bA,function(){bA._iO.onerror.apply(bA,[bC,bB]);
});}};this._onbufferchange=function(bB){if(bA.playState===0){return false;}if((bB&&bA.isBuffering)||(!bB&&!bA.isBuffering)){return false;}bA.isBuffering=(bB===1);
if(bA._iO.onbufferchange){bA._iO.onbufferchange.apply(bA,[bB]);}return true;};this._onsuspend=function(){if(bA._iO.onsuspend){bA._iO.onsuspend.apply(bA);
}return true;};this._onfailure=function(bC,bD,bB){bA.failures++;if(bA._iO.onfailure&&bA.failures===1){bA._iO.onfailure(bC,bD,bB);}else{}};this._onwarning=function(bC,bD,bB){if(bA._iO.onwarning){bA._iO.onwarning(bC,bD,bB);
}};this._onfinish=function(){var bB=bA._iO.onfinish;bA._onbufferchange(0);bA._resetOnPosition(0);if(bA.instanceCount){bA.instanceCount--;if(!bA.instanceCount){bo();
bA.playState=0;bA.paused=false;bA.instanceCount=0;bA.instanceOptions={};bA._iO={};bm();if(bA.isHTML5){bA.position=0;}}if(!bA.instanceCount||bA._iO.multiShotEvents){if(bB){aE(bA,function(){bB.apply(bA);
});}}}};this._whileloading=function(bB,bC,bF,bE){var bD=bA._iO;bA.bytesLoaded=bB;bA.bytesTotal=bC;bA.duration=Math.floor(bF);bA.bufferLength=bE;if(!bA.isHTML5&&!bD.isMovieStar){if(bD.duration){bA.durationEstimate=(bA.duration>bD.duration)?bA.duration:bD.duration;
}else{bA.durationEstimate=parseInt((bA.bytesTotal/bA.bytesLoaded)*bA.duration,10);}}else{bA.durationEstimate=bA.duration;}if(!bA.isHTML5){bA.buffered=[{start:0,end:bA.duration}];
}if((bA.readyState!==3||bA.isHTML5)&&bD.whileloading){bD.whileloading.apply(bA);}};this._whileplaying=function(bD,bE,bH,bC,bG){var bF=bA._iO,bB;if(isNaN(bD)||bD===null){return false;
}bA.position=Math.max(0,bD);bA._processOnPosition();if(!bA.isHTML5&&bi>8){if(bF.usePeakData&&bE!==d&&bE){bA.peakData={left:bE.leftPeak,right:bE.rightPeak};
}if(bF.useWaveformData&&bH!==d&&bH){bA.waveformData={left:bH.split(","),right:bC.split(",")};}if(bF.useEQData){if(bG!==d&&bG&&bG.leftEQ){bB=bG.leftEQ.split(",");
bA.eqData=bB;bA.eqData.left=bB;if(bG.rightEQ!==d&&bG.rightEQ){bA.eqData.right=bG.rightEQ.split(",");}}}}if(bA.playState===1){if(!bA.isHTML5&&bi===8&&!bA.position&&bA.isBuffering){bA._onbufferchange(0);
}if(bF.whileplaying){bF.whileplaying.apply(bA);}}return true;};this._oncaptiondata=function(bB){bA.captiondata=bB;if(bA._iO.oncaptiondata){bA._iO.oncaptiondata.apply(bA,[bB]);
}};this._onmetadata=function(bE,bB){var bF={},bD,bC;for(bD=0,bC=bE.length;bD<bC;bD++){bF[bE[bD]]=bB[bD];}bA.metadata=bF;if(bA._iO.onmetadata){bA._iO.onmetadata.call(bA,bA.metadata);
}};this._onid3=function(bE,bB){var bF=[],bD,bC;for(bD=0,bC=bE.length;bD<bC;bD++){bF[bE[bD]]=bB[bD];}bA.id3=a3(bA.id3,bF);if(bA._iO.onid3){bA._iO.onid3.apply(bA);
}};this._onconnect=function(bB){bB=(bB===1);bA.connected=bB;if(bB){bA.failures=0;if(I(bA.id)){if(bA.getAutoPlay()){bA.play(d,bA.getAutoPlay());}else{if(bA._iO.autoLoad){bA.load();
}}}if(bA._iO.onconnect){bA._iO.onconnect.apply(bA,[bB]);}}};this._ondataerror=function(bB){if(bA.playState>0){if(bA._iO.ondataerror){bA._iO.ondataerror.apply(bA);
}}};};bg=function(){return(Z.body||Z.getElementsByTagName("div")[0]);};ao=function(bl){return Z.getElementById(bl);};a3=function(bm,bl){var bo=(bm||{}),bn,bp;
bn=(bl===d?ap.defaultOptions:bl);for(bp in bn){if(bn.hasOwnProperty(bp)&&bo[bp]===d){if(typeof bn[bp]!=="object"||bn[bp]===null){bo[bp]=bn[bp];}else{bo[bp]=a3(bo[bp],bn[bp]);
}}}return bo;};aE=function(bl,bm){if(!bl.isHTML5&&bi===8){c.setTimeout(bm,0);}else{bm();}};a4={onready:1,ontimeout:1,defaultOptions:1,flash9Options:1,movieStarOptions:1};
a7=function(br,bq){var bp,bm=true,bl=(bq!==d),bo=ap.setupOptions,bn=a4;for(bp in br){if(br.hasOwnProperty(bp)){if(typeof br[bp]!=="object"||br[bp]===null||br[bp] instanceof Array||br[bp] instanceof RegExp){if(bl&&bn[bq]!==d){ap[bq][bp]=br[bp];
}else{if(bo[bp]!==d){ap.setupOptions[bp]=br[bp];ap[bp]=br[bp];}else{if(bn[bp]===d){bm=false;}else{if(ap[bp] instanceof Function){ap[bp].apply(ap,(br[bp] instanceof Array?br[bp]:[br[bp]]));
}else{ap[bp]=br[bp];}}}}}else{if(bn[bp]===d){bm=false;}else{return a7(br[bp],bp);}}}}return bm;};function bj(bl){return(ap.preferFlash&&au&&!ap.ignoreFlash&&(ap.flash[bl]!==d&&ap.flash[bl]));
}am=(function(){var bn=(c.attachEvent),bm={add:(bn?"attachEvent":"addEventListener"),remove:(bn?"detachEvent":"removeEventListener")};function bp(bt){var bs=R.call(bt),br=bs.length;
if(bn){bs[1]="on"+bs[1];if(br>3){bs.pop();}}else{if(br===3){bs.push(false);}}return bs;}function bo(br,bu){var bs=br.shift(),bt=[bm[bu]];if(bn){bs[bt](br[0],br[1]);
}else{bs[bt].apply(bs,br);}}function bq(){bo(bp(arguments),"add");}function bl(){bo(bp(arguments),"remove");}return{add:bq,remove:bl};}());function aQ(bl){return function(bo){var bn=this._s,bm;
if(!bn||!bn._a){bm=null;}else{bm=bl.call(this,bo);}return bm;};}i={abort:aQ(function(){}),canplay:aQ(function(){var bn=this._s,bm;if(bn._html5_canplay){return;
}bn._html5_canplay=true;bn._onbufferchange(0);bm=(bn._iO.position!==d&&!isNaN(bn._iO.position)?bn._iO.position/h:null);if(this.currentTime!==bm){try{this.currentTime=bm;
}catch(bl){}}if(bn._iO._oncanplay){bn._iO._oncanplay();}}),canplaythrough:aQ(function(){var bl=this._s;if(!bl.loaded){bl._onbufferchange(0);bl._whileloading(bl.bytesLoaded,bl.bytesTotal,bl._get_html5_duration());
bl._onload(true);}}),durationchange:aQ(function(){var bl=this._s,bm;bm=bl._get_html5_duration();if(!isNaN(bm)&&bm!==bl.duration){bl.durationEstimate=bl.duration=bm;
}}),ended:aQ(function(){var bl=this._s;bl._onfinish();}),error:aQ(function(){var bl=(aO[this.error.code]||null);this._s._onload(false);this._s._onerror(this.error.code,bl);
}),loadeddata:aQ(function(){var bl=this._s;if(!bl._loaded&&!aZ){bl.duration=bl._get_html5_duration();}}),loadedmetadata:aQ(function(){}),loadstart:aQ(function(){this._s._onbufferchange(1);
}),play:aQ(function(){this._s._onbufferchange(0);}),playing:aQ(function(){this._s._onbufferchange(0);}),progress:aQ(function(bq){var bu=this._s,bp,bn,bt,bm=0,bs=(bq.type==="progress"),bl=bq.target.buffered,bo=(bq.loaded||0),br=(bq.total||1);
bu.buffered=[];if(bl&&bl.length){for(bp=0,bn=bl.length;bp<bn;bp++){bu.buffered.push({start:bl.start(bp)*h,end:bl.end(bp)*h});}bm=(bl.end(0)-bl.start(0))*h;
bo=Math.min(1,bm/(bq.target.duration*h));}if(!isNaN(bo)){bu._whileloading(bo,br,bu._get_html5_duration());if(bo&&br&&bo===br){i.canplaythrough.call(this,bq);
}}}),ratechange:aQ(function(){}),suspend:aQ(function(bm){var bl=this._s;i.progress.call(this,bm);bl._onsuspend();}),stalled:aQ(function(){}),timeupdate:aQ(function(){this._s._onTimer();
}),waiting:aQ(function(){var bl=this._s;bl._onbufferchange(1);})};bb=function(bm){var bl;if(!bm||(!bm.type&&!bm.url&&!bm.serverURL)){bl=false;}else{if(bm.serverURL||(bm.type&&bj(bm.type))){bl=false;
}else{bl=((bm.type?an({type:bm.type}):an({url:bm.url})||ap.html5Only||bm.url.match(/data:/i)));}}return bl;};g=function(bl){var bm;if(bl){bm=(aZ?n:(ap.html5.canPlayType("audio/wav")?aT:n));
bl.src=bm;if(bl._called_unload!==d){bl._called_load=false;}}if(a0){k=null;}return bm;};an=function(bs){if(!ap.useHTML5Audio||!ap.hasHTML5){return false;
}var bo=(bs.url||null),bq=(bs.type||null),bm=ap.audioFormats,bl,br,bn,bp;if(bq&&ap.html5[bq]!==d){return(ap.html5[bq]&&!bj(bq));}if(!aL){aL=[];for(bp in bm){if(bm.hasOwnProperty(bp)){aL.push(bp);
if(bm[bp].related){aL=aL.concat(bm[bp].related);}}}aL=new RegExp("\\.("+aL.join("|")+")(\\?.*)?$","i");}bn=(bo?bo.toLowerCase().match(aL):null);if(!bn||!bn.length){if(!bq){bl=false;
}else{br=bq.indexOf(";");bn=(br!==-1?bq.substr(0,br):bq).substr(6);}}else{bn=bn[1];}if(bn&&ap.html5[bn]!==d){bl=(ap.html5[bn]&&!bj(bn));}else{bq="audio/"+bn;
bl=ap.html5.canPlayType({type:bq});ap.html5[bn]=bl;bl=(bl&&ap.html5[bq]&&!bj(bq));}return bl;};aN=function(){if(!ap.useHTML5Audio||!ap.hasHTML5){ap.html5.usingFlash=true;
B=true;return false;}var bl=(Audio!==d?(u&&opera.version()<10?new Audio(null):new Audio()):null),bp,br,bo={},bm,bn;function bq(bu){var bw,bv,bt=false,bs=false;
if(!bl||typeof bl.canPlayType!=="function"){return bt;}if(bu instanceof Array){for(bn=0,bv=bu.length;bn<bv;bn++){if(ap.html5[bu[bn]]||bl.canPlayType(bu[bn]).match(ap.html5Test)){bs=true;
ap.html5[bu[bn]]=true;ap.flash[bu[bn]]=!!(bu[bn].match(q));}}bt=bs;}else{bw=(bl&&typeof bl.canPlayType==="function"?bl.canPlayType(bu):false);bt=!!(bw&&(bw.match(ap.html5Test)));
}return bt;}bm=ap.audioFormats;for(bp in bm){if(bm.hasOwnProperty(bp)){br="audio/"+bp;bo[bp]=bq(bm[bp].type);bo[br]=bo[bp];if(bp.match(q)){ap.flash[bp]=true;
ap.flash[br]=true;}else{ap.flash[bp]=false;ap.flash[br]=false;}if(bm[bp]&&bm[bp].related){for(bn=bm[bp].related.length-1;bn>=0;bn--){bo["audio/"+bm[bp].related[bn]]=bo[bp];
ap.html5[bm[bp].related[bn]]=bo[bp];ap.flash[bm[bp].related[bn]]=bo[bp];}}}}bo.canPlayType=(bl?bq:null);ap.html5=a3(ap.html5,bo);ap.html5.usingFlash=S();
B=ap.html5.usingFlash;return true;};e={};bf=function(){};A=function(bl){if(bi===8&&bl.loops>1&&bl.stream){bl.stream=false;}return bl;};o=function(bm,bl){if(bm&&!bm.usePolicyFile&&(bm.onid3||bm.usePeakData||bm.useWaveformData||bm.useEQData)){bm.usePolicyFile=true;
}return bm;};at=function(bl){};T=function(){return false;};W=function(bm){var bl;for(bl in bm){if(bm.hasOwnProperty(bl)&&typeof bm[bl]==="function"){bm[bl]=T;
}}bl=null;};r=function(bl){if(bl===d){bl=false;}if(a2||bl){ap.disable(bl);}};aA=function(bn){var bl=null,bm;if(bn){if(bn.match(/\.swf(\?.*)?$/i)){bl=bn.substr(bn.toLowerCase().lastIndexOf(".swf?")+4);
if(bl){return bn;}}else{if(bn.lastIndexOf("/")!==bn.length-1){bn+="/";}}}bm=(bn&&bn.lastIndexOf("/")!==-1?bn.substr(0,bn.lastIndexOf("/")+1):"./")+ap.movieURL;
if(ap.noSWFCache){bm+=("?ts="+new Date().getTime());}return bm;};aW=function(){bi=parseInt(ap.flashVersion,10);if(bi!==8&&bi!==9){ap.flashVersion=bi=X;
}var bl=(ap.debugMode||ap.debugFlash?"_debug.swf":".swf");if(ap.useHTML5Audio&&!ap.html5Only&&ap.audioFormats.mp4.required&&bi<9){ap.flashVersion=bi=9;
}ap.version=ap.versionNumber+(ap.html5Only?" (HTML5-only mode)":(bi===9?" (AS3/Flash 9)":" (AS2/Flash 8)"));if(bi>8){ap.defaultOptions=a3(ap.defaultOptions,ap.flash9Options);
ap.features.buffering=true;ap.defaultOptions=a3(ap.defaultOptions,ap.movieStarOptions);ap.filePatterns.flash9=new RegExp("\\.(mp3|"+U.join("|")+")(\\?.*)?$","i");
ap.features.movieStar=true;}else{ap.features.movieStar=false;}ap.filePattern=ap.filePatterns[(bi!==8?"flash9":"flash8")];ap.movieURL=(bi===8?"soundmanager2.swf":"soundmanager2_flash9.swf").replace(".swf",bl);
ap.features.peakData=ap.features.waveformData=ap.features.eqData=(bi>8);};l=function(bl,bm){if(!ad){return;}ad._setPolling(bl,bm);};D=function(){};I=this.getSoundById;
m=function(){var bl=[];if(ap.debugMode){bl.push(E.sm2Debug);}if(ap.debugFlash){bl.push(E.flashDebug);}if(ap.useHighPerformance){bl.push(E.highPerf);}return bl.join(" ");
};aB=function(){var bm=bf("fbHandler"),bo=ap.getMoviePercent(),bn=E,bl={type:"FLASHBLOCK"};if(ap.html5Only){return;}if(!ap.ok()){if(B){ap.oMC.className=m()+" "+bn.swfDefault+" "+(bo===null?bn.swfTimedout:bn.swfError);
}ap.didFlashBlock=true;aS({type:"ontimeout",ignoreInit:true,error:bl});aa(bl);}else{if(ap.oMC){ap.oMC.className=[m(),bn.swfDefault,bn.swfLoaded+(ap.didFlashBlock?" "+bn.swfUnblocked:"")].join(" ");
}}};Y=function(bn,bm,bl){if(v[bn]===d){v[bn]=[];}v[bn].push({method:bm,scope:(bl||null),fired:false});};aS=function(br){if(!br){br={type:(ap.ok()?"onready":"ontimeout")};
}if(!ay&&br&&!br.ignoreInit){return false;}if(br.type==="ontimeout"&&(ap.ok()||(a2&&!br.ignoreInit))){return false;}var bn={success:(br&&br.ignoreInit?ap.ok():!a2)},bm=(br&&br.type?v[br.type]||[]:[]),bl=[],bs,bq,bp=[bn],bo=(B&&!ap.ok());
if(br.error){bp[0].error=br.error;}for(bs=0,bq=bm.length;bs<bq;bs++){if(bm[bs].fired!==true){bl.push(bm[bs]);}}if(bl.length){for(bs=0,bq=bl.length;bs<bq;
bs++){if(bl[bs].scope){bl[bs].method.apply(bl[bs].scope,bp);}else{bl[bs].method.apply(this,bp);}if(!bo){bl[bs].fired=true;}}}return true;};s=function(){c.setTimeout(function(){if(ap.useFlashBlock){aB();
}aS();if(typeof ap.onload==="function"){ap.onload.apply(c);}if(ap.waitForWindowLoad){am.add(c,"load",s);}},1);};Q=function(){if(au!==d){return au;}var bl=false,bs=navigator,br,bn,bm,bq=c.ActiveXObject;
var bo;try{bo=bs.plugins;}catch(bp){bo=undefined;}if(bo&&bo.length){bn="application/x-shockwave-flash";bm=bs.mimeTypes;if(bm&&bm[bn]&&bm[bn].enabledPlugin&&bm[bn].enabledPlugin.description){bl=true;
}}else{if(bq!==d&&!av.match(/MSAppHost/i)){try{br=new bq("ShockwaveFlash.ShockwaveFlash");}catch(bp){br=null;}bl=(!!br);br=null;}}au=bl;return bl;};S=function(){var bm,bo,bl=ap.audioFormats,bn=(aX&&!!(av.match(/os (1|2|3_0|3_1)\s/i)));
if(bn){ap.hasHTML5=false;ap.html5Only=true;if(ap.oMC){ap.oMC.style.display="none";}}else{if(ap.useHTML5Audio){if(!ap.html5||!ap.html5.canPlayType){ap.hasHTML5=false;
}}}if(ap.useHTML5Audio&&ap.hasHTML5){af=true;for(bo in bl){if(bl.hasOwnProperty(bo)){if(bl[bo].required){if(!ap.html5.canPlayType(bl[bo].type)){af=false;
bm=true;}else{if(ap.preferFlash&&(ap.flash[bo]||ap.flash[bl[bo].type])){bm=true;}}}}}}if(ap.ignoreFlash){bm=false;af=true;}ap.html5Only=(ap.hasHTML5&&ap.useHTML5Audio&&!bm);
return(!ap.html5Only);};ab=function(bn){var bp,bm,bo=0,bl;if(bn instanceof Array){for(bp=0,bm=bn.length;bp<bm;bp++){if(bn[bp] instanceof Object){if(ap.canPlayMIME(bn[bp].type)){bo=bp;
break;}}else{if(ap.canPlayURL(bn[bp])){bo=bp;break;}}}if(bn[bo].url){bn[bo]=bn[bo].url;}bl=bn[bo];}else{bl=bn;}return bl;};aP=function(bl){if(!bl._hasTimer){bl._hasTimer=true;
if(!aU&&ap.html5PollingInterval){if(be===null&&K===0){be=setInterval(ae,ap.html5PollingInterval);}K++;}}};N=function(bl){if(bl._hasTimer){bl._hasTimer=false;
if(!aU&&ap.html5PollingInterval){K--;}}};ae=function(){var bl;if(be!==null&&!K){clearInterval(be);be=null;return;}for(bl=ap.soundIDs.length-1;bl>=0;bl--){if(ap.sounds[ap.soundIDs[bl]].isHTML5&&ap.sounds[ap.soundIDs[bl]]._hasTimer){ap.sounds[ap.soundIDs[bl]]._onTimer();
}}};aa=function(bl){bl=(bl!==d?bl:{});if(typeof ap.onerror==="function"){ap.onerror.apply(c,[{type:(bl.type!==d?bl.type:null)}]);}if(bl.fatal!==d&&bl.fatal){ap.disable();
}};C=function(){if(!a6||!Q()){return;}var bl=ap.audioFormats,bm,bn;for(bn in bl){if(bl.hasOwnProperty(bn)){if(bn==="mp3"||bn==="mp4"){ap.html5[bn]=false;
if(bl[bn]&&bl[bn].related){for(bm=bl[bn].related.length-1;bm>=0;bm--){ap.html5[bl[bn].related[bm]]=false;}}}}}};this._setSandboxType=function(bl){};this._externalInterfaceOK=function(bl){if(ap.swfLoaded){return;
}var bm;ap.swfLoaded=true;ba=false;if(a6){C();}setTimeout(aJ,a8?100:1);};H=function(by,bn){if(aq&&aV){return false;}function bA(){}if(ap.html5Only){aW();
bA();ap.oMC=ao(ap.movieID);aJ();aq=true;aV=true;return false;}var bx=(bn||ap.url),bt=(ap.altURL||bx),bE="JS/Flash audio component (SoundManager 2)",bw=bg(),bv=m(),bl=null,bp=Z.getElementsByTagName("html")[0],bB,bq,bC,bu,bs,br,bo,bD;
bl=(bp&&bp.dir&&bp.dir.match(/rtl/i));by=(by===d?ap.id:by);function bm(bF,bG){return'<param name="'+bF+'" value="'+bG+'" />';}aW();ap.url=aA(G?bx:bt);bn=ap.url;
ap.wmode=(!ap.wmode&&ap.useHighPerformance?"transparent":ap.wmode);if(ap.wmode!==null&&(av.match(/msie 8/i)||(!a8&&!ap.useHighPerformance))&&navigator.platform.match(/win32|win64/i)){ar.push(e.spcWmode);
ap.wmode=null;}bB={name:by,id:by,src:bn,quality:"high",allowScriptAccess:ap.allowScriptAccess,bgcolor:ap.bgColor,pluginspage:aM+"www.macromedia.com/go/getflashplayer",title:bE,type:"application/x-shockwave-flash",wmode:ap.wmode,hasPriority:"true"};
if(ap.debugFlash){bB.FlashVars="debug=1";}if(!ap.wmode){delete bB.wmode;}if(a8){bq=Z.createElement("div");bu=['<object id="'+by+'" data="'+bn+'" type="'+bB.type+'" title="'+bB.title+'" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">',bm("movie",bn),bm("AllowScriptAccess",ap.allowScriptAccess),bm("quality",bB.quality),(ap.wmode?bm("wmode",ap.wmode):""),bm("bgcolor",ap.bgColor),bm("hasPriority","true"),(ap.debugFlash?bm("FlashVars",bB.FlashVars):""),"</object>"].join("");
}else{bq=Z.createElement("embed");for(bC in bB){if(bB.hasOwnProperty(bC)){bq.setAttribute(bC,bB[bC]);}}}D();bv=m();bw=bg();if(bw){ap.oMC=(ao(ap.movieID)||Z.createElement("div"));
if(!ap.oMC.id){ap.oMC.id=ap.movieID;ap.oMC.className=E.swfDefault+" "+bv;br=null;bs=null;if(!ap.useFlashBlock){if(ap.useHighPerformance){br={position:"fixed",width:"8px",height:"8px",bottom:"0px",left:"0px",overflow:"hidden"};
}else{br={position:"absolute",width:"6px",height:"6px",top:"-9999px",left:"-9999px"};if(bl){br.left=Math.abs(parseInt(br.left,10))+"px";}}}if(aG){ap.oMC.style.zIndex=10000;
}if(!ap.debugFlash){for(bo in br){if(br.hasOwnProperty(bo)){ap.oMC.style[bo]=br[bo];}}}try{if(!a8){ap.oMC.appendChild(bq);}bw.appendChild(ap.oMC);if(a8){bs=ap.oMC.appendChild(Z.createElement("div"));
bs.className=E.swfBox;bs.innerHTML=bu;}aV=true;}catch(bz){throw new Error(bf("domError")+" \n"+bz.toString());}}else{bD=ap.oMC.className;ap.oMC.className=(bD?bD+" ":E.swfDefault)+(bv?" "+bv:"");
ap.oMC.appendChild(bq);if(a8){bs=ap.oMC.appendChild(Z.createElement("div"));bs.className=E.swfBox;bs.innerHTML=bu;}aV=true;}}aq=true;bA();return true;};
j=function(){if(ap.html5Only){H();return false;}if(ad){return false;}if(!ap.url){return false;}ad=ap.getMovie(ap.id);if(!ad){if(!aK){H(ap.id,ap.url);}else{if(!a8){ap.oMC.appendChild(aK);
}else{ap.oMC.innerHTML=ak;}aK=null;aq=true;}ad=ap.getMovie(ap.id);}if(typeof ap.oninitmovie==="function"){setTimeout(ap.oninitmovie,1);}return true;};y=function(){setTimeout(bd,1000);
};ac=function(){c.setTimeout(function(){ap.setup({preferFlash:false}).reboot();ap.didFlashBlock=true;ap.beginDelayedInit();},1);};bd=function(){var bm,bl=false;
if(!ap.url){return;}if(aR){return;}aR=true;am.remove(c,"load",y);if(au&&ba&&!aC){return;}if(!ay){bm=ap.getMoviePercent();if(bm>0&&bm<100){bl=true;}}setTimeout(function(){bm=ap.getMoviePercent();
if(bl){aR=false;c.setTimeout(y,1);return;}if(!ay&&az){if(bm===null){if(ap.useFlashBlock||ap.flashLoadTimeout===0){if(ap.useFlashBlock){aB();}}else{if(!ap.useFlashBlock&&af){ac();
}else{aS({type:"ontimeout",ignoreInit:true,error:{type:"INIT_FLASHBLOCK"}});}}}else{if(ap.flashLoadTimeout===0){}else{if(!ap.useFlashBlock&&af){ac();}else{r(true);
}}}}},ap.flashLoadTimeout);};t=function(){function bl(){am.remove(c,"focus",t);}if(aC||!ba){bl();return true;}az=true;aC=true;aR=false;y();bl();return true;
};P=function(){};aF=function(){};w=function(bo){if(ay){return false;}if(ap.html5Only){ay=true;s();return true;}var bm=(ap.useFlashBlock&&ap.flashLoadTimeout&&!ap.getMoviePercent()),bl=true,bn;
if(!bm){ay=true;}bn={type:(!au&&B?"NO_FLASH":"INIT_TIMEOUT")};if(a2||bo){if(ap.useFlashBlock&&ap.oMC){ap.oMC.className=m()+" "+(ap.getMoviePercent()===null?E.swfTimedout:E.swfError);
}aS({type:"ontimeout",error:bn,ignoreInit:true});aa(bn);bl=false;}else{}if(!a2){if(ap.waitForWindowLoad&&!bc){am.add(c,"load",s);}else{s();}}return bl;
};z=function(){var bl,bm=ap.setupOptions;for(bl in bm){if(bm.hasOwnProperty(bl)){if(ap[bl]===d){ap[bl]=bm[bl];}else{if(ap[bl]!==bm[bl]){ap.setupOptions[bl]=ap[bl];
}}}}};aJ=function(){if(ay){return false;}function bl(){am.remove(c,"load",ap.beginDelayedInit);}if(ap.html5Only){if(!ay){bl();ap.enabled=true;w();}return true;
}j();try{ad._externalInterfaceTest(false);l(true,(ap.flashPollingInterval||(ap.useHighPerformance?10:50)));if(!ap.debugMode){ad._disableDebug();}ap.enabled=true;
if(!ap.html5Only){am.add(c,"unload",T);}}catch(bm){aa({type:"JS_TO_FLASH_EXCEPTION",fatal:true});r(true);w();return false;}w();bl();return true;};L=function(){if(p){return false;
}p=true;z();D();if(!au&&ap.hasHTML5){ap.setup({useHTML5Audio:true,preferFlash:false});}aN();if(!au&&B){ar.push(e.needFlash);ap.setup({flashLoadTimeout:1});
}if(Z.removeEventListener){Z.removeEventListener("DOMContentLoaded",L,false);}j();return true;};O=function(){if(Z.readyState==="complete"){L();Z.detachEvent("onreadystatechange",O);
}return true;};bk=function(){bc=true;L();am.remove(c,"load",bk);};Q();am.add(c,"focus",t);am.add(c,"load",y);am.add(c,"load",bk);if(Z.addEventListener){Z.addEventListener("DOMContentLoaded",L,false);
}else{if(Z.attachEvent){Z.attachEvent("onreadystatechange",O);}else{aa({type:"NO_DOM2_EVENTS",fatal:true});}}}if(c.SM2_DEFER===d||!SM2_DEFER){b=new a();
}if(typeof module==="object"&&module&&typeof module.exports==="object"){module.exports.SoundManager=a;module.exports.soundManager=b;}else{if(typeof define==="function"&&define.amd){define(function(){function e(g){if(!c.soundManager&&g instanceof Function){var f=g(a);
if(f instanceof a){c.soundManager=f;}}return c.soundManager;}return{constructor:a,getInstance:e};});}}c.SoundManager=a;c.soundManager=b;}(window));